rem @echo off
echo.
echo -==========================================================================-
echo - Symantec NoNAV 1.18a
echo -       - Removes NAVCE / SAVCE, ver 4, 5, 7, 8, 9, client and server
echo -       - Removes Symantec System Center and AMS2
echo -       - Removes Symantec Client Firewall 5.x / 7.x
echo -       - On Windows 2003, XP, 2000, NT, Me and 9x
echo -

rem  ============================================================================
rem  NoNAV Options
rem  ============================================================================
set REMOVE_SYMEVENT=0
set REMOVE_LIVEUPDATE=0
set REMOVE_CQUARANTINE=0
set REMOVE_DEFS=0
set REMOVE_LOGS=1
set WARN_FIRST=1
set REBOOT=1
set NNLOG=c:\nonav.log
if exist %nnlog% del /q %nnlog%

rem  ============================================================================
if "%1" == "-silent" set WARN_FIRST=0
if "%2" == "-silent" set WARN_FIRST=0
if "%1" == "win9xrun" goto WIN9XRUN
echo - Settings (can be changed in nonav.bat):
echo - Remove Symevent driver: %REMOVE_SYMEVENT%
echo - Remove Symantec LiveUpdate: %REMOVE_LIVEUPDATE%
echo - Remove Central Quarantine / Quarantine Console: %REMOVE_CQUARANTINE%
echo - Remove Symantec Shared Virus Definitions/Decomposers: %REMOVE_DEFS%
echo - Remove Install Log files for products being removed: %REMOVE_LOGS%
echo - Prompt before running: %WARN_FIRST%       (use "nonav -silent" to avoid)
echo - Restart when done: %REBOOT%           (0=no, 1=if needed, 2=always)
echo - NoNAV Log file saved to: "%nnlog%"
echo -==========================================================================-
echo.
echo.
if not "%1" == "" if not "%1" == "-silent" echo Invalid command line parameter. Use "NONAV" or "NONAV -silent"
if not "%1" == "" if not "%1" == "-silent" goto EXIT

rem  ============================================================================
rem  Files:
rem  nonav.bat		this file
rem  nonav.reg		remove registry keys for NAVCE / SAVCE
rem  nonav.inf		remove registry keys for NAVCE / SAVCE (Hebrew Windows)
rem  nolu.reg		remove registry keys for LiveUpdate
rem  nolu.inf		remove registry keys for LiveUpdate (Hebrew Windows)
rem  noquar.reg		remove registry keys for Quarantine
rem  noquar.inf		remove registry keys for Quarantine (Hebrew Windows)
rem  nonav.pif		make nonav.bat window close when finished (win9x)
rem  ESUGUnEn.exe	Symantec tool, by Enterprise Support Utilities Group
rem  UnEngVar.Txt	used by ESUGUnEn.exe to read paths from registry.
rem  UnEngVar.BAT	used by ESUGUnEn.exe to read paths from registry.
rem  rtvstop.exe	Symantec tool
rem  autorun.iff	tells nonav.exe self extractor where to extract / what to run.
rem  nonav.pdf		Nonav documentation.
rem  nonav.txt		Nonav readme.
rem  ============================================================================


echo ================================ NoNAV start =============================== >> "%nnlog%"
echo NoNav started at %date% and %time% >> %nnlog%
echo.>>%nnlog%
echo - Settings: >> "%nnlog%"
echo - Remove Symevent driver: %REMOVE_SYMEVENT% >> "%nnlog%"
echo - Remove Symantec LiveUpdate: %REMOVE_LIVEUPDATE% >> "%nnlog%"
echo - Remove Central Quarantine / Quarantine Console: %REMOVE_CQUARANTINE% >> "%nnlog%"
echo - Remove Symantec Shared Virus Definitions/Decomposers: %REMOVE_DEFS% >> "%nnlog%"
echo - Remove Install Log files for products being removed: %REMOVE_LOGS% >> "%nnlog%"
echo - Prompt before running: %WARN_FIRST%       (use "nonav -silent" to avoid) >> "%nnlog%"
echo - Restart when done: %REBOOT%           (0=no, 1=if needed, 2=always) >> "%nnlog%"
echo. >> %nnlog%
echo. >> %nnlog%
if "%WARN_FIRST%" == "0" echo ===================== no warning set - starting nonav ======================
if "%WARN_FIRST%" == "0" goto NONAV
if "%REBOOT%" == "1" ESUGUnEn /LF"%nnlog%" /MESSAGE"This will remove NAVCE and Symantec AV version 4, 5, 7, 8, 9, SCF, SSC, SCS 2.0 and AMS from the filesystem and registry, and restart the computer. Do you want to continue?" /MSGI0 /MSGB2
if "%REBOOT%" == "2" ESUGUnEn /LF"%nnlog%" /MESSAGE"This will remove NAVCE and Symantec AV version 4, 5, 7, 8, 9, SCF, SSC, and AMS from the filesystem and registry, and restart the computer. Do you want to continue?" /MSGI0 /MSGB2
if not "%REBOOT%" == "1" if not "%REBOOT%" == "2" ESUGUnEn /LF"%nnlog%" /MESSAGE"This will remove NAVCE and Symantec AV version 4, 5, 7, 8, 9, SCF, SSC, SCS 2.0 and AMS from the filesystem and registry. Do you want to continue?" /MSGI0 /MSGB2
if errorlevel 5 if not errorlevel 6 goto NONAV
goto EXIT

:NONAV
set needreboot=0
if "%OS%" == "Windows_NT" goto WINNT

:WIN9X
rem have to do this to avoid running out of environment space
%COMSPEC% /E:4096 /C %0 win9xrun %1
goto EXIT
:WIN9XRUN
echo ============================ OS is Windows 9X ==============================

echo =========================== delete loading points ==========================
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run" "vptray"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run" "Norton Auto-Protect"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run" "NPS Event Checker"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run" "ccApp"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run" "IS Config"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run" "IAMAPP"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\RunServices" "rtvscn95"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\RunServices" "defwatch"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\RunServices" "Rtvscan"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\RunServices" "ccEvtMgr"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\RunServices" "ccProxy"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\RunServices" "ccSetMgr"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\RunServices" "SymPortGrabber"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\RunServices" "SndSrvc"
rem wait a while to make sure changes are written to registry.
echo Wait 5 seconds...
esugunen /pause"5000"

echo ========================== stop running processes ==========================
echo If nonav should hang in this section reboot the machine and run nonav again.
echo.
REM Doing it the old fashioned way first.
call :CheckServices
echo RTVSTOP
rtvstop.exe
rem wait a while to avoid hang on /killp rtvscn95
echo Wait 5 seconds...
esugunen /pause"5000"
echo navapw32.exe
ESUGUnEn /LF"%nnlog%" /KILLP"navapw32.exe"
echo vptray.exe
ESUGUnEn /LF"%nnlog%" /KILLP"vptray.exe"
echo defwatch.exe
ESUGUnEn /LF"%nnlog%" /KILLP"defwatch.exe"
echo rtvscn95.exe
ESUGUnEn /LF"%nnlog%" /KILLP"rtvscn95.exe"
echo vpc32.exe
ESUGUnEn /LF"%nnlog%" /KILLP"vpc32.exe"
echo vpdn_lu.exe
ESUGUnEn /LF"%nnlog%" /KILLP"vpdn_lu.exe"
echo ccevtmgr.exe
ESUGUnEn /LF"%nnlog%" /KILLP"ccevtmgr.exe"
echo ccproxy.exe
ESUGUnEn /LF"%nnlog%" /KILLP"ccproxy.exe"
echo ccsetmgr.exe
ESUGUnEn /LF"%nnlog%" /KILLP"ccsetmgr.exe"
echo symsport.exe
ESUGUnEn /LF"%nnlog%" /KILLP"symsport.exe"
echo ccapp.exe
ESUGUnEn /LF"%nnlog%" /KILLP"ccapp.exe"
echo sndsrvc.exe
ESUGUnEn /LF"%nnlog%" /KILLP"sndsrvc.exe"
echo iamstats.exe
ESUGUnEn /LF"%nnlog%" /KILLP"iamstats.exe"
echo iamapp.exe
ESUGUnEn /LF"%nnlog%" /KILLP"IAMAPP.EXE"
echo atrack.exe
ESUGUnEn /LF"%nnlog%" /KILLP"ATrack.exe"
echo introwiz.exe
ESUGUnEn /LF"%nnlog%" /KILLP"introwiz.exe"
echo NISUM.EXE
ESUGUnEn /LF"%nnlog%" /KILLP"NISUM.EXE"
echo NISSERV.EXE
ESUGUnEn /LF"%nnlog%" /KILLP"NISSERV.EXE"
echo SymPxSvc.exe
ESUGUnEn /LF"%nnlog%" /KILLP"SymPxSvc.exe"

echo ========================= set environment variables ========================
echo ---------- env before ESUGUnEn /mkvarbat ---------- >> %nnlog%
set >> %nnlog%
echo -------------------- >> %nnlog%
echo. > UnEngVar.BAT
ESUGUnEn /LF"%nnlog%" /mkvarbat
call UnEngVar.bat
echo ---------- env after ESUGUnEn /mkvarbat ---------- >> %nnlog%
set >> %nnlog%
echo -------------------- >> %nnlog%
if "%windir%" == "" set windir=c:\windows
if not defined ProgramFiles (set ProgramFiles=%ProgFiles%)
if not defined CommonProgramFiles (set CommonProgramFiles=%CProgFiles%)
set StartMenuPr=%UStartMenuPr%
set StartMenuSt=%UStartMenuSt%
if exist "%windir%\Men Inicio\Programas\nul" set startmenupr=%windir%\Men Inicio\Programas
if exist "%windir%\Men Inicio\Programas\Inicio\nul" set startmenust=%windir%\Men Inicio\Programas\Inicio
if exist "%windir%\Menu Dmarrer\Programmes\nul" set startmenupr=%windir%\Menu Dmarrer\Programmes
if exist "%windir%\Menu Dmarrer\Programmes\Dmarrage\nul" set startmenust=%windir%\Menu Dmarrer\Programmes\Dmarrage
if exist "%windir%\Startmen\Programme\*.*" set startmenupr=%windir%\Startmen\Programme
if exist "%windir%\Startmen\Programme\Autostart\*.*" set startmenust=%windir%\Startmen\Programme\Autostart
echo ---------- env before delete ---------- >> %nnlog%
set >> %nnlog%
echo -------------------- >> %nnlog%
echo windir = %windir% >> %nnlog%
echo progfiles = %progfiles% >> %nnlog%
echo programfiles = %programfiles% >> %nnlog%
echo cprogfiles = %cprogfiles% >> %nnlog%
echo commonprogramfiles = %commonprogramfiles% >> %nnlog%
echo StartMenuPr = %StartMenuPr% >> %nnlog%
echo StartMenuSt = %StartMenuSt% >> %nnlog%
echo CAppData = %CAppData% >> %nnlog%
echo StartMenuPr=%UStartMenuPr% >> %nnlog%
echo StartMenuSt=%UStartMenuSt% >> %nnlog%
echo. >> %nnlog%
rem wait a while to make sure processes are unloaded fully and the files can be deleted.
echo Wait 5 seconds...
esugunen /pause"5000"

echo ====== delete files - change paths in nonav.bat if not using default =======
echo.>>%nnlog%
deltree /y "%StartMenuPr%\Symantec Client Security"
echo Errorlevel from 'deltree /y "%StartMenuPr%\Symantec Client Security" ' is %errorlevel% >> %nnlog%
deltree /y "%StartMenuPr%\Norton AntiVirus"
echo Errorlevel from 'deltree /y "%StartMenuPr%\Norton AntiVirus" ' is %errorlevel% >> %nnlog%
deltree /y "%StartMenuPr%\Norton AntiVirus Corporate Edition"
echo Errorlevel from 'deltree /y "%StartMenuPr%\Norton AntiVirus Corporate Edition" ' is %errorlevel% >> %nnlog%
deltree /y "%ProgramFiles%\Norton AntiVirus"
echo Errorlevel from 'deltree /y "%ProgramFiles%\Norton AntiVirus" ' is %errorlevel% >> %nnlog%
deltree /y "%ProgramFiles%\Symantec_Client_Security"
echo Errorlevel from 'deltree /y "%ProgramFiles%\Symantec_Client_Security" ' is %errorlevel% >> %nnlog%
deltree /y "%ProgramFiles%\Symantec Client Security"
echo Errorlevel from 'deltree /y "%ProgramFiles%\Symantec Client Security" ' is %errorlevel% >> %nnlog%
deltree /y "%ProgramFiles%\Symantec AntiVirus"
echo Errorlevel from 'deltree /y "%ProgramFiles%\Symantec AntiVirus" ' is %errorlevel% >> %nnlog%
deltree /y "%CommonProgramFiles%\Symantec Shared\SSC"
echo Errorlevel from 'deltree /y "%CommonProgramFiles%\Symantec Shared\SSC" ' is %errorlevel% >> %nnlog%
deltree /y "%CommonProgramFiles%\Symantec Shared\Licenses\Scs"
echo Errorlevel from 'deltree /y "%CommonProgramFiles%\Symantec Shared\Licenses\Scs" ' is %errorlevel% >> %nnlog%
deltree /y "%CommonProgramFiles%\Symantec Shared\IDSDefs"
echo Errorlevel from 'deltree /y "%CommonProgramFiles%\Symantec Shared\IDSDefs" ' is %errorlevel% >> %nnlog%
deltree /y "%CommonProgramFiles%\Symantec Shared\AdBlocking"
echo Errorlevel from 'deltree /y "%CommonProgramFiles%\Symantec Shared\AdBlocking" ' is %errorlevel% >> %nnlog%
deltree /y "%CAppData%\Symantec\Symantec Client Firewall"
echo Errorlevel from 'deltree /y "%CAppData%\Symantec\Symantec Client Firewall" ' is %errorlevel% >> %nnlog%
deltree /y "%CAppData%\Symantec\Common Client"
echo Errorlevel from 'deltree /y "%CAppData%\Symantec\Common Client" ' is %errorlevel% >> %nnlog%
echo.>>%nnlog%

del "%CommonProgramFiles%\Symantec Shared\Help\ad_block.chm"
del "%windir%\VPC32.INI"
del "%CommonProgramFiles%\Symantec Shared\PFAdBlk.dll"
del "%CommonProgramFiles%\Symantec Shared\ccEmlPxy.dll"
del "%CommonProgramFiles%\Symantec Shared\ccErrDsp.dll"
del "%CommonProgramFiles%\Symantec Shared\ccEvtMgr.exe"
del "%CommonProgramFiles%\Symantec Shared\ccLgView.exe"
del "%CommonProgramFiles%\Symantec Shared\CCLGVIEW.CHM"
del "%CommonProgramFiles%\Symantec Shared\PxyHTTP.dll"
del "%CommonProgramFiles%\Symantec Shared\PxyIM.dll"
del "%CommonProgramFiles%\Symantec Shared\PxyNNTP.dll"
del "%CommonProgramFiles%\Symantec Shared\ccAlert.dll"
del "%CommonProgramFiles%\Symantec Shared\ccApp.exe"
del "%CommonProgramFiles%\Symantec Shared\ccLogin.dll"
del "%CommonProgramFiles%\Symantec Shared\ccProSub.dll"
del "%CommonProgramFiles%\Symantec Shared\ccProd.dll"
del "%CommonProgramFiles%\Symantec Shared\StrmFilt.dll"
del "%CommonProgramFiles%\Symantec Shared\SymIConv.dll"
del "%CommonProgramFiles%\Symantec Shared\ccProxy.exe"
del "%CommonProgramFiles%\Symantec Shared\ccPxyEvt.dll"
del "%CommonProgramFiles%\Symantec Shared\DPHTML.dll"
del "%CommonProgramFiles%\Symantec Shared\DPVBS.dll"
del "%CommonProgramFiles%\Symantec Shared\DPHTTP.dll"
del "%CommonProgramFiles%\Symantec Shared\DPJS.dll"
del "%CommonProgramFiles%\Symantec Shared\PFMisc.dll"
del "%CommonProgramFiles%\Symantec Shared\PFPriv.dll"
del "%CommonProgramFiles%\Symantec Shared\PFSec.dll"
del "%CommonProgramFiles%\Symantec Shared\ccPwd.dll"
del "%CommonProgramFiles%\Symantec Shared\ccPwdSvc.exe"
del "%CommonProgramFiles%\Symantec Shared\ccScan.dll"
esugunen /LF"%nnlog%" /delfile"%CommonProgramFiles%\Symantec Shared\ecmldr32.DLL"
del "%CommonProgramFiles%\Symantec Shared\ecmldr32.DLL"
del "%CommonProgramFiles%\Symantec Shared\ccDec.dll"
del "%CommonProgramFiles%\Symantec Shared\ccSetMgr.exe"
del "%CommonProgramFiles%\Symantec Shared\ccSetEvt.dll"
del "%CommonProgramFiles%\Symantec Shared\ccSet.dll"
del "%CommonProgramFiles%\Symantec Shared\ccVrTrst.dll"
del "%CommonProgramFiles%\Symantec Shared\ccWebWnd.dll"
esugunen /LF"%nnlog%" /delfile"%CommonProgramFiles%\Symantec Shared\Default.rul"
del "%CommonProgramFiles%\Symantec Shared\Default.rul"
del "%CommonProgramFiles%\Symantec Shared\Validate.dat"
del "%CommonProgramFiles%\Symantec Shared\SNDSrvc.exe"
del "%CommonProgramFiles%\Symantec Shared\SNDInst.exe"
del "%CommonProgramFiles%\Symantec Shared\CfgWiz.exe"
del "%CommonProgramFiles%\Symantec Shared\SMNLnch.exe"
del "%CommonProgramFiles%\Symantec Shared\SymLCUI.dll"
del "%CommonProgramFiles%\Symantec Shared\SymLTCHK.dll"
del "%CommonProgramFiles%\Symantec Shared\SymLTCOM.dll"
del "%CommonProgramFiles%\Symantec Shared\SymUIAx.ocx"
del "%CommonProgramFiles%\Symantec Shared\SymUIHlp.dll"
del "%CommonProgramFiles%\Symantec Shared\actres.dll"
esugunen /LF"%nnlog%" /delfile"%CommonProgramFiles%\Symantec Shared\cfgwiz.tlb"
del "%CommonProgramFiles%\Symantec Shared\cfgwiz.tlb"
del "%CommonProgramFiles%\Symantec Shared\drWebWnd.dll"
del "%CommonProgramFiles%\Symantec Shared\FIREWALL.RUL"
del "%CommonProgramFiles%\Symantec Shared\FIREWALL.BAK"
del "%CommonProgramFiles%\Symantec Shared\Persist.Dat"
del "%CommonProgramFiles%\Symantec Shared\Persist.BAK"
del "%CommonProgramFiles%\Symantec Shared\profile.dat"
del "%CommonProgramFiles%\Symantec Shared\SNDSYS.log"
del "%CommonProgramFiles%\Symantec Shared\SNDFW.log"
del "%CommonProgramFiles%\Symantec Shared\SNDCON.log"
del "%CommonProgramFiles%\Symantec Shared\SNDALRT.log"
del "%CommonProgramFiles%\Symantec Shared\SNDIDS.log"
del "%CommonProgramFiles%\Symantec Shared\SNDDBG.log"
del "%CommonProgramFiles%\Symantec Shared\LocationMap.dat"
del "%windir%\system\symids.vxd"
del "%windir%\system\SymIDSCo.vxd"
del "%windir%\system\symdns.vxd"
del "%windir%\system\symredrv.vxd"
del "%windir%\system\symfw.vxd"
del "%windir%\system\symndis.vxd"
del "%windir%\system\symtdi.vxd"
del "%windir%\system\SymRedir.dll"
del "%windir%\system\SymNeti.dll"
esugunen /LF"%nnlog%" /delfile"%windir%\system\cba.dll"
del "%windir%\system\cba.dll"
esugunen /LF"%nnlog%" /delfile"%windir%\system\msgsys.dll"
del "%windir%\system\msgsys.dll"
esugunen /LF"%nnlog%" /delfile"%windir%\system\nts.dll"
del "%windir%\system\nts.dll"
esugunen /LF"%nnlog%" /delfile"%windir%\system\pds.dll"
del "%windir%\system\pds.dll"
del "%windir%\Tasks\Symantec NetDetect.job"
deltree /y "%windir%\Installer\{7D2B86CA-2D5D-469E-92ED-E56B62BD1D3C}"
echo Errorlevel from 'deltree /y "%windir%\Installer\{7D2B86CA-2D5D-469E-92ED-E56B62BD1D3C}" ' is %errorlevel% >> %nnlog%
if "%REMOVE_LOGS%" == "1" del "%temp%\SCS_INST.LOG"
if "%REMOVE_LOGS%" == "1" del "%temp%\SAV_INST.LOG"

echo =============================== nav5 cleanup ===============================
if exist c:\autoexec.nav move c:\autoexec.nav c:\autoexec.bat
del "%windir%\SCHEDULE.INI"
del "%windir%\NLOGOS.SYS"
del "%windir%\NLOGOW.SYS"
del "%windir%\NavUStub.exe"
del "%windir%\TASKS\Scan For Viruses.job"

echo =========================== remove registry keys ===========================
start /wait regedit /s nonav.reg
rem ======== remove reg keys using .inf (.reg doesn't work on hebrew OS) =======
rundll.exe setupx.dll,InstallHinfSection DefaultInstall 132 %0\..\nonav.inf
rundll.exe setupx.dll,InstallHinfSection DefaultInstall 132 "%0\..\nonav.inf"
rundll.exe setupx.dll,InstallHinfSection DefaultInstall 132 c:\temp\nonav.inf

if "%REMOVE_DEFS%" == "1" echo =================== remove virus definitions/decomposers ===================
if "%REMOVE_DEFS%" == "1" deltree/y "%CommonProgramFiles%\Symantec Shared\VirusDefs"
if "%REMOVE_DEFS%" == "1" deltree/y "%CommonProgramFiles%\Symantec Shared\Decomposers"


if not "%REMOVE_SYMEVENT%" == "1" goto SKIPEV9X
echo ========================== remove symevent files ===========================
call :GetSymEvtApps
call :RemoveSymEvent
echo.>> %nnlog%
del "%ProgramFiles%\Symantec\SYMEVNT.386"
echo Errorlevel from 'del "%ProgramFiles%\Symantec\SYMEVNT.386" ' is %errorlevel >> %nnlog%
del "%ProgramFiles%\Symantec\S32EVNT1.DLL"
echo Errorlevel from 'del "%ProgramFiles%\Symantec\S32EVNT1.DLL" ' is %errorlevel >> %nnlog%
del "%ProgramFiles%\Symantec\SYMEVENT.SYS"
echo Errorlevel from 'del "%ProgramFiles%\Symantec\SYMEVENT.SYS" ' is %errorlevel >> %nnlog%
del "%ProgramFiles%\Symantec\SYMEVENT.INF"
echo Errorlevel from 'del "%ProgramFiles%\Symantec\SYMEVENT.INF" ' is %errorlevel >> %nnlog%
del "%ProgramFiles%\Symantec\SYMEVENT.CAT"
echo Errorlevel from ' del "%ProgramFiles%\Symantec\SYMEVENT.CAT"' is %errorlevel >> %nnlog%
del "%CommonProgramFiles%\Symantec Shared\Sevinst.exe"
echo Errorlevel from 'del "%CommonProgramFiles%\Symantec Shared\Sevinst.exe" ' is %errorlevel >> %nnlog%
del "%windir%\system\SYMEVNT.386"
echo Errorlevel from 'del "%windir%\system\SYMEVNT.386" ' is %errorlevel >> %nnlog%
del "%windir%\system\S32EVNT1.DLL"
echo Errorlevel from 'del "%windir%\system\S32EVNT1.DLL" ' is %errorlevel >> %nnlog%
echo.>> %nnlog%
:SKIPEV9X

if not "%REMOVE_LIVEUPDATE%" == "1" goto SKIPLU9X
echo ========================= remove liveupdate files ==========================
if exist "%windir%\system\s32lucp1.cpl" (del /q "%windir%\system\s32lucp1.cpl")
echo Errorlevel from '"del %windir%\system\s32lucp1.cpl" ' is %errorlevel% >> %nnlog%
deltree /y "%ProgramFiles%\symantec\liveupdate"
echo Errorlevel from 'deltree /y "%ProgramFiles%\symantec\liveupdate" ' is %errorlevel% >> %nnlog%
deltree /y "%CAppData%\Symantec\LiveUpdate"
echo Errorlevel from 'deltree /y "%CAppData%\Symantec\LiveUpdate" ' is %errorlevel% >> %nnlog%
if exist  "%CommonProgramFiles%\Symantec Shared\Help\LUALL.chm" (del /q "%CommonProgramFiles%\Symantec Shared\Help\LUALL.chm")
echo Errorlevel from 'del "%CommonProgramFiles%\Symantec Shared\Help\LUALL.chm" ' is %errorlevel% >> %nnlog%
echo.>> %nnlog%
echo ======================== remove liveupdate reg keys ========================
start /wait regedit /s nolu.reg
rem =================== remove liveupdate reg keys using .inf ===================
rundll.exe setupx.dll,InstallHinfSection DefaultInstall 132 %0\..\nolu.inf
rundll.exe setupx.dll,InstallHinfSection DefaultInstall 132 "%0\..\nolu.inf"
rundll.exe setupx.dll,InstallHinfSection DefaultInstall 132 c:\temp\nolu.inf
:SKIPLU9X

rem ================== if all files successfully deleted exit ===================
if exist "%ProgramFiles%\Norton AntiVirus\*.*" goto DELBOOT9X
if exist "%ProgramFiles%\Symantec_Client_Security\*.*" goto DELBOOT9X
if exist "%ProgramFiles%\Symantec Client Security\*.*" goto DELBOOT9X
goto DELREG2

:DELBOOT9X
echo ============ delete remaining files on restart using wininit.ini ===========
for %%f in ("%ProgramFiles%\Norton AntiVirus\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Norton AntiVirus\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Norton AntiVirus\"
for %%f in ("%ProgramFiles%\Symantec AntiVirus\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec AntiVirus\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec AntiVirus\"
for %%f in ("%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\"
for %%f in ("%ProgramFiles%\Symantec Client Security\Symantec AntiVirus\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec Client Security\Symantec AntiVirus\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec Client Security\Symantec AntiVirus\"
for %%f in ("%ProgramFiles%\Symantec Client Security\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec Client Security\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec Client Security\"
for %%f in ("%ProgramFiles%\Symantec_Client_Security\Symantec Client Firewall\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec_Client_Security\Symantec Client Firewall\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec_Client_Security\Symantec Client Firewall\"
for %%f in ("%ProgramFiles%\Symantec_Client_Security\Symantec AntiVirus\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec_Client_Security\Symantec AntiVirus\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec_Client_Security\Symantec AntiVirus\"
for %%f in ("%ProgramFiles%\Symantec_Client_Security\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec_Client_Security\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec_Client_Security\"
echo =============================== wininit.ini ================================
type "%windir%\wininit.ini"
echo ---------- wininit.ini ----------   >> "%nnlog%"
type "%windir%\wininit.ini"  >> "%nnlog%"
echo --------------------   >> "%nnlog%"
echo ============================================================================
set needreboot=1
goto DELREG2
rem =========================== end of win9x section ============================

REM =========================== Stoping Symantec / Norton Services ==============
REM
:CheckServices
echo. >> %nnlog%
echo Services running at %time%: >> %nnlog%
if exist NetStart.txt del /q NetStart.txt
net start > NetStart.txt
echo Running Services: >> %nnlog%
type NetStart.txt >> %nnlog%
echo. >> %nnlog%
set TheService=
for /f "skip=2 delims=$" %%a in (NetStart.txt) do call :IdentService "%%a"
del /q NetStart.txt
goto :eof

:IdentService
set tmpvar=%1
if not defined tmpvar goto :eof
set tmpvar=%tmpvar:(=%
set tmpvar=%tmpvar:)=%
set tmpvar=%tmpvar:"=%
for %%a in (FirstWord SecondWord ThirdWord FourthWord) do set %%a=
for /f "tokens=1,2,3,4" %%a in ('echo %tmpvar%') do call :FindSymantec %%a %%b %%c %%d
goto :eof

:FindSymantec
set TheService=
set FirstWord=%1
set SecondWord=%2
set ThirdWord=%3
set Fourthword=%4
if /i %FirstWord%==Symantec goto :FoundSymAV
if /i %FirstWord%==Savroam (set TheService=SavRoam) & (goto :StopService)
if /i %FirstWord%==Navroam (set TheService=NavRoam) & (goto :StopService)
if /i %FirstWord%==RoamAdmin (set TheService=RoamAdmin) & (goto :StopService)
if /i %FirstWord%==pcAnywhere (set TheService=pcAnywhere) & (goto :StopService)
if /i not %FirstWord%==Norton goto :eof

:FoundSymAV
set TheService="%FirstWord% %SecondWord%"
if not defined ThirdWord goto :StopService
set TheService=%TheService% %ThirdWord%
if not defined FourthWord goto :StopService
set TheService="%TheService% %FourthWord%"
set OtherService=%TheService%

:StopService
set TheService=%TheService:"=%
echo Attempting to stop the "%TheService%" service at %time% >> %nnlog%
Net Stop "%TheService%"
set StopCode=%Errorlevel%
If %StopCode% GTR 0 (Echo Unable to stop "%TheService%" at %time% - Errorlevel = %Stopcode%>> %nnlog%) else (echo Stopped "%TheService%" at %time% >> %nnlog%)
goto :eof
REM
REM ======================= End Stoping Symantec / Norton Services ==============

REM ================== UnHooking SymEvent from the installed products ===========
REM
:GetSymEvtApps
echo UnHooking SymEvent from the installed products. >> %nnlog%
set MakeLast=
if exist SymEvtRegApps.txt del /q SymEvtRegApps.txt
if exist SymEvtApps.txt del /q SymEvtApps.txt
ESUGENum.exe /k HKEY_LOCAL_MACHINE "SOFTWARE\Symantec\Symevent" > SymEvtRegApps.txt
for /f "delims=$" %%a in (SymEvtRegApps.txt) do (set hivename="%%a") & (call :GetSymHives)
if defined MakeLast (echo.%MakeLast%>>SymEvtApps.txt)
echo Applications listed as using SymEvent per HKEY_LOCAL_MACHINE\SOFTWARE\Symantec\Symevent >> %nnlog%
type SymEvtApps.txt>>%nnlog%
call :RemoveSymEvent
if exist SymEvtRegApps.txt del /q SymEvtRegApps.txt
if exist SymEvtApps.txt del /q SymEvtApps.txt
goto :eof

:GetSymHives
if "%hivename%"=="" goto :eof
set hivename=%hivename:"=%
if /i %hivename%==VDD goto :eof
if /i %hivename%==SAVCE (set MakeLast=%Hivename%) & (goto :eof)
if /i %hivename%==NAVNT (set MakeLast=%Hivename%) & (goto :eof)
echo.%hivename%>>SymEvtApps.txt
goto :eof

:RemoveSymEvent
echo.>> %nnlog%
echo Uninstalling SymEvent >> %nnlog%
for /f "delims=$" %%a in (SymEvtApps.txt) do call :UnInstallSymEvt %%a
goto :eof

:UnInstallSymEvt
set ProdID=
set ProdID=%1
echo Uninstalling SymEvent for Product ID %ProdID% >> %nnlog%
SEVINST.EXE /U /Q /LOG /%ProdID% /NODEL
echo.>> %nnlog%
if exist "%windir%\Symevent.log" (type "%windir%\Symevent.log" >> %nnlog%)
if exist "%windir%\Symevent.log" del /q "%windir%\Symevent.log"
echo. >> %nnlog%
goto :eof
REM
REM ================ End UnHooking SymEvent from the installed products ==========

:WINNT
 
echo =============================== OS is winNT ================================

echo =========================== delete loading points ==========================
rem do this first so that if nonav hangs killing processes it can run cleanly after a reboot
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\VxD\NAVAP"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\VxD\SYMTDI"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\VxD\SAVRTPEL"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\VxD\SAVRT"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NAV Alert"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NAV Auto-Protect"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NAVAP"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NAVAPEL"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NAVENG"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NAVEX15"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Norton Program Scheduler"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Intel Alert Handler"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Intel Alert Originator"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Intel File Transfer"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Intel PDS"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DefWatch"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Norton AntiVirus Server"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Norton AntiVirus Client"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Symantec Antivirus Server"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Symantec Antivirus Client"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Symantec System Center Discovery Service"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\nsctop"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\savroam"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\navroam"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Symantec Antivirus"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Symantec AntiVirus Definition Watcher"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SAVRT"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SAVRTPEL"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SYMTDI"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SYMREDRV"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SNDSrvc"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\ccPwdSvc"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\ccEvtMgr"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\ccSetMgr"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\ccProxy"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SYMDNS"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SYMFW"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SYMIDS"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SYMIDSCO"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SYMNDIS"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SymSecurePort"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NISSERV"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NISUM"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SymPxSvc"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run" "vptray"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run" "Norton Auto-Protect"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run" "NPS Event Checker"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run" "ccApp"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run" "IS Config"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Run" "IAMAPP"

echo =============== stop and delete services and stop processes ================
echo If nonav should hang in this section reboot the machine and run nonav again.
REM Doing it the old fashioned way first.
call :CheckServices
echo.
echo vptray.exe
ESUGUnEn /LF"%nnlog%" /KILLP"vptray.exe"
echo navapw32.exe
ESUGUnEn /LF"%nnlog%" /KILLP"navapw32.exe"
echo ccApp.exe
ESUGUnEn /LF"%nnlog%" /KILLP"ccApp.exe"
echo vpc32.exe
ESUGUnEn /LF"%nnlog%" /KILLP"vpc32.exe"
echo amsadmin.exe
ESUGUnEn /LF"%nnlog%" /KILLP"amsadmin.exe"
echo ALEScan.exe
ESUGUnEn /LF"%nnlog%" /KILLP"ALEScan.exe"
echo iamstats.exe
ESUGUnEn /LF"%nnlog%" /KILLP"iamstats.exe"
echo iamapp.exe
ESUGUnEn /LF"%nnlog%" /KILLP"IAMAPP.EXE"
echo atrack.exe
ESUGUnEn /LF"%nnlog%" /KILLP"ATrack.exe"
echo vpdn_lu.exe
ESUGUnEn /LF"%nnlog%" /KILLP"vpdn_lu.exe"
if "%REMOVE_LIVEUPDATE%" == "1" ESUGUnEn /LF"%nnlog%" /KILLP"lucoms~1.exe"
if "%REMOVE_LIVEUPDATE%" == "1" ESUGUnEn /LF"%nnlog%" /KILLP"luall.exe"
echo NAV Alert
ESUGUnEn /LF"%nnlog%" /delserv"NAV Alert" && set needreboot=1
echo NAV Auto-Protect
ESUGUnEn /LF"%nnlog%" /delserv"NAV Auto-Protect" && set needreboot=1
echo Norton Program Scheduler
ESUGUnEn /LF"%nnlog%" /delserv"Norton Program Scheduler" && set needreboot=1
echo Intel Alert Handler
ESUGUnEn /LF"%nnlog%" /delserv"Intel Alert Handler" && set needreboot=1
echo Intel Alert Originator
ESUGUnEn /LF"%nnlog%" /delserv"Intel Alert Originator" && set needreboot=1
echo Intel File Transfer
ESUGUnEn /LF"%nnlog%" /delserv"Intel File Transfer" && set needreboot=1
echo Intel PDS
ESUGUnEn /LF"%nnlog%" /delserv"Intel PDS" && set needreboot=1
echo DefWatch
ESUGUnEn /LF"%nnlog%" /delserv"DefWatch" && set needreboot=1
rem need "net stop" on these two services to avoid hang on NT4
echo Norton AntiVirus Server
net stop "Norton AntiVirus Server"
ESUGUnEn /LF"%nnlog%" /delserv"Norton AntiVirus Server" && set needreboot=1
echo Norton AntiVirus Client
net stop "Norton AntiVirus Client"
ESUGUnEn /LF"%nnlog%" /delserv"Norton AntiVirus Client" && set needreboot=1
echo Symantec Antivirus Server
ESUGUnEn /LF"%nnlog%" /delserv"Symantec Antivirus Server" && set needreboot=1
echo Symantec Antivirus Client
ESUGUnEn /LF"%nnlog%" /delserv"Symantec Antivirus Client" && set needreboot=1
echo Symantec System Center Discovery Service
ESUGUnEn /LF"%nnlog%" /delserv"Symantec System Center Discovery Service" && set needreboot=1
ESUGUnEn /LF"%nnlog%" /delserv"nsctop" && set needreboot=1
echo navroam
ESUGUnEn /LF"%nnlog%" /delserv"navroam" && set needreboot=1
echo savroam
ESUGUnEn /LF"%nnlog%" /delserv"savroam" && set needreboot=1
echo Symantec Antivirus
ESUGUnEn /LF"%nnlog%" /delserv"Symantec Antivirus" && set needreboot=1
echo Symantec AntiVirus Definition Watcher
ESUGUnEn /LF"%nnlog%" /delserv"Symantec AntiVirus Definition Watcher" && set needreboot=1
echo Symantec Network Drivers Service
ESUGUnEn /LF"%nnlog%" /delserv"Symantec Network Drivers Service" && set needreboot=1
ESUGUnEn /LF"%nnlog%" /delserv"SNDSrvc" && set needreboot=1
echo Symantec Password Validation
ESUGUnEn /LF"%nnlog%" /delserv"Symantec Password Validation" && set needreboot=1
ESUGUnEn /LF"%nnlog%" /delserv"ccPwdSvc" && set needreboot=1
echo Symantec Event Manager
ESUGUnEn /LF"%nnlog%" /delserv"Symantec Event Manager" && set needreboot=1
ESUGUnEn /LF"%nnlog%" /delserv"ccEvtMgr" && set needreboot=1
echo Symantec Settings Manager
ESUGUnEn /LF"%nnlog%" /delserv"Symantec Settings Manager" && set needreboot=1
ESUGUnEn /LF"%nnlog%" /delserv"ccSetMgr" && set needreboot=1
echo Symantec Network Proxy
ESUGUnEn /LF"%nnlog%" /delserv"Symantec Network Proxy" && set needreboot=1
ESUGUnEn /LF"%nnlog%" /delserv"ccProxy" && set needreboot=1
echo Symantec SecurePort
ESUGUnEn /LF"%nnlog%" /delserv"Symantec SecurePort" && set needreboot=1
ESUGUnEn /LF"%nnlog%" /delserv"SymSecurePort" && set needreboot=1
echo Symantec Client Firewall Accounts Manager
ESUGUnEn /LF"%nnlog%" /delserv"Symantec Client Firewall Accounts Manager" && set needreboot=1
echo Symantec Client Firewall Proxy Service
ESUGUnEn /LF"%nnlog%" /delserv"Symantec Client Firewall Proxy Service" && set needreboot=1
echo Symantec Client Firewall Service
ESUGUnEn /LF"%nnlog%" /delserv"Symantec Client Firewall Service" && set needreboot=1
 

if not "%REMOVE_CQUARANTINE%" == "1" goto SKIPQUPROC
echo ====================== stop quarantine server services =====================
echo Symantec Quarantine Agent
ESUGUnEn /LF"%nnlog%" /delserv"Symantec Quarantine Agent" && set needreboot=1
ESUGUnEn /LF"%nnlog%" /delserv"IcePack" && set needreboot=1
echo Symantec Quarantine Scanner
ESUGUnEn /LF"%nnlog%" /delserv"Symantec Quarantine Scanner" && set needreboot=1
ESUGUnEn /LF"%nnlog%" /delserv"ScanExplicit" && set needreboot=1
echo Symantec Central Quarantine
ESUGUnEn /LF"%nnlog%" /delserv"Symantec Central Quarantine" && set needreboot=1
ESUGUnEn /LF"%nnlog%" /delserv"qserver" && set needreboot=1
:SKIPQUPROC

echo =========================== remove registry keys ===========================
regedit /s nonav.reg
rem ======== remove reg keys using .inf (.reg doesn't work on hebrew OS) ========
rundll32.exe setupapi,InstallHinfSection DefaultInstall 132 .\nonav.inf

echo ========================= set environment variables ========================
echo ---------- env before ESUGUnEn /mkvarbat ---------- >> %nnlog%
set >> %nnlog%
echo -------------------- >> %nnlog%
echo. > UnEngVar.BAT
ESUGUnEn /LF"%nnlog%" /mkvarbat
call UnEngVar.bat
echo ---------- env after ESUGUnEn /mkvarbat ---------- >> %nnlog%
set >> %nnlog%
set
 
echo -------------------- >> %nnlog%
if not defined ProgFiles (set ProgFiles=%ProgramFiles%)
if not defined CProgFiles (set CProgFiles=%CommonProgramFiles%)
if not defined ProgramFiles (set ProgramFiles=%ProgFiles%)
if not defined CommonProgramFiles (set CommonProgramFiles=%CProgFiles%)
if not defined ALLUSERSPROFILE (set ALLUSERSPROFILE=%SystemRoot%\Profiles\All Users)
if not defined CAppData (set CAppData=%ALLUSERSPROFILE%\Application Data)
if not defined DULAppData (set DULAppData=%ALLUSERSPROFILE:All Users=Default User%\Local Settings\Application Data)
if not defined UAppData (set UAppData=%AppData%)
if not defined ULAppData (set ULAppData=%AppData%)
if not defined DUAppData (set DUAppData=%AppData%)
if not defined StartMenuPr (set StartMenuPr=%ALLUSERSPROFILE%\Start Menu\Programs)
if not defined StartMenuSt (set StartMenuSt=%ALLUSERSPROFILE%\Start Menu)

if exist "%ALLUSERSPROFILE%\Men Inicio\Programas\*.*" set startmenupr=%ALLUSERSPROFILE%\Men Inicio\Programas
if exist "%ALLUSERSPROFILE%\Men Inicio\Programas\Inicio\*.*" set startmenust=%ALLUSERSPROFILE%\Men Inicio\Programas\Inicio
if exist "%ALLUSERSPROFILE%\Menu Dmarrer\Programmes\*.*" set startmenupr=%ALLUSERSPROFILE%\Menu Dmarrer\Programmes
if exist "%ALLUSERSPROFILE%\Menu Dmarrer\Programmes\Dmarrage\*.*" set startmenust=%ALLUSERSPROFILE%\Menu Dmarrer\Programmes\Dmarrage
if exist "%ALLUSERSPROFILE%\Startmen\Programme\*.*" set startmenupr=%ALLUSERSPROFILE%\Startmen\Programme
if exist "%ALLUSERSPROFILE%\Startmen\Programme\Autostart\*.*" set startmenust=%ALLUSERSPROFILE%\Startmen\Programme\Autostart

echo.>> %nnlog%
echo Selected Enviromental variables: >> %nnlog%
echo "ProgramFiles"="%ProgramFiles%" >> %nnlog%
echo "CommonProgramFiles"="%CommonProgramFiles%" >> %nnlog%
echo "ALLUSERSPROFILE"="%ALLUSERSPROFILE%" >> %nnlog%
echo "UAppData"="%AppData%" >> %nnlog%
echo "StartMenuPr"="%StartMenuPr%" >> %nnlog%
echo "StartMenuSt"="%StartMenuSt%" >> %nnlog%
echo "CAppData"="%CAppData%" >> %nnlog%
echo "UAppData"="%UAppData%" >> %nnlog%
echo "ULAppData"="%ULAppData%" >> %nnlog%
echo "DUAppData"="%DUAppData%" >> %nnlog%
echo "DULAppData"="%DULAppData%" >> %nnlog%
echo.>> %nnlog%
 
echo ---------- env before delete ---------- >> %nnlog%
echo. >> %nnlog%
echo All Enviromental Variables: >> %nnlog%
set >> %nnlog%
echo -------------------- >> %nnlog%
set windir
set ProgFiles
set ProgramFiles
set CProgFiles
set CommonProgramFiles
set StartMenuPr
set StartMenuSt
set CAppData
set UAppData
set ULAppData
set DUAppData
set DULAppData
set allusersprofile
 

echo =============================== remove files ===============================
echo. >> %nnlog%
rd /s/q "%StartMenuPr%\Norton AntiVirus Corporate Edition\"
echo Errorlevel from 'rd /s/q "%StartMenuPr%\Norton AntiVirus Corporate Edition\"' is %errorlevel% >> %nnlog%
rd /s/q "%StartMenuPr%\Norton AntiVirus\"
echo Errorlevel from 'rd /s/q "%StartMenuPr%\Norton AntiVirus\"' is %errorlevel% >> %nnlog%
rd /s/q "%StartMenuPr%\Alert Management Server\"
echo Errorlevel from 'rd /s/q "%StartMenuPr%\Alert Management Server\" ' is %errorlevel% >> %nnlog%
rd /s/q "%StartMenuPr%\Symantec Client Security\"
echo Errorlevel from 'rd /s/q "%StartMenuPr%\Symantec Client Security\"' is %errorlevel% >> %nnlog%
rd /s/q "%StartMenuPr%\Symantec System Center\"
echo Errorlevel from 'rd /s/q "%StartMenuPr%\Symantec System Center\"' is %errorlevel% >> %nnlog%
rd /s/q "%StartMenuPr%\Symantec System Center Console\"
echo Errorlevel from 'rd /s/q "%StartMenuPr%\Symantec System Center Console\"' is %errorlevel% >> %nnlog%
rd /s/q "%ProgramFiles%\NAVNT\"
echo Errorlevel from 'rd /s/q "%ProgramFiles%\NAVNT\"' is %errorlevel% >> %nnlog%
rd /s/q "%ProgramFiles%\NAV\"
echo Errorlevel from 'rd /s/q "%ProgramFiles%\NAV\"' is %errorlevel% >> %nnlog%
rd /s/q "%CAppData%\Symantec\Norton AntiVirus Corporate Edition\"
echo Errorlevel from'rd /s/q "%CAppData%\Symantec\Norton AntiVirus Corporate Edition\" 'is %errorlevel% >> %nnlog%
rd /s/q "%CAppData%\Symantec\Symantec AntiVirus Corporate Edition\"
echo Errorlevel from'rd /s/q "%CAppData%\Symantec\Symantec AntiVirus Corporate Edition\" 'is %errorlevel% >> %nnlog%
rd /s/q "%UAppData%\Symantec\Norton AntiVirus Corporate Edition\"
echo Errorlevel from'rd /s/q "%UAppData%\Symantec\Norton AntiVirus Corporate Edition\" 'is %errorlevel% >> %nnlog%
rd /s/q "%UAppData%\Symantec\Symantec AntiVirus Corporate Edition\"
echo Errorlevel from'rd /s/q "%UAppData%\Symantec\Symantec AntiVirus Corporate Edition\" 'is %errorlevel% >> %nnlog%
rd /s/q "%ULAppData%\Symantec\Norton AntiVirus Corporate Edition\"
echo Errorlevel from'rd /s/q "%ULAppData%\Symantec\Norton AntiVirus Corporate Edition\" 'is %errorlevel% >> %nnlog%
rd /s/q "%ULAppData%\Symantec\Symantec AntiVirus Corporate Edition\"
echo Errorlevel from'rd /s/q "%ULAppData%\Symantec\Symantec AntiVirus Corporate Edition\" 'is %errorlevel% >> %nnlog%
rd /s/q "%DULAppData%\Symantec\Norton AntiVirus Corporate Edition\"
echo Errorlevel from'rd /s/q "%DULAppData%\Symantec\Norton AntiVirus Corporate Edition\" 'is %errorlevel% >> %nnlog%
rd /s/q "%DULAppData%\Symantec\Symantec AntiVirus Corporate Edition\"
echo Errorlevel from'rd /s/q "%DULAppData%\Symantec\Symantec AntiVirus Corporate Edition\" 'is %errorlevel% >> %nnlog%
rd /s/q "%ProgramFiles%\SAV\"
echo Errorlevel from'rd /s/q "%ProgramFiles%\SAV\" 'is %errorlevel% >> %nnlog%
rd /s/q "%ProgramFiles%\Symantec AntiVirus\"
echo Errorlevel from'rd /s/q "%ProgramFiles%\Symantec AntiVirus\" 'is %errorlevel% >> %nnlog%
rd /s/q "%ProgramFiles%\Norton AntiVirus\"
echo Errorlevel from'rd /s/q "%ProgramFiles%\Norton AntiVirus\" 'is %errorlevel% >> %nnlog%
rd /s/q "%ProgramFiles%\Symantec_Client_Security\"
echo Errorlevel from'rd /s/q "%ProgramFiles%\Symantec_Client_Security\" 'is %errorlevel% >> %nnlog%
rd /s/q "%SystemRoot%\system32\AMS_II\"
echo Errorlevel from'rd /s/q "%SystemRoot%\system32\AMS_II\" 'is %errorlevel% >> %nnlog%
rd /s/q "%SystemRoot%\system32\cba\"
echo Errorlevel from'rd /s/q "%SystemRoot%\system32\cba\" 'is %errorlevel% >> %nnlog%
rd /s/q "%CommonProgramFiles%\Symantec Shared\SSC\"
echo Errorlevel from'rd /s/q "%CommonProgramFiles%\Symantec Shared\SSC\" 'is %errorlevel% >> %nnlog%
rd /s/q "%ProgramFiles%\SSC\"
echo Errorlevel from'rd /s/q "%ProgramFiles%\SSC\" 'is %errorlevel% >> %nnlog%
rd /s/q "%ProgramFiles%\SYMANTEC\Symantec System Center\"
echo Errorlevel from'rd /s/q "%ProgramFiles%\SYMANTEC\Symantec System Center\" 'is %errorlevel% >> %nnlog%
rd /s/q "%SystemRoot%\Installer\{7D2B86CA-2D5D-469E-92ED-E56B62BD1D3C}\"
echo Errorlevel from'rd /s/q "%SystemRoot%\Installer\{7D2B86CA-2D5D-469E-92ED-E56B62BD1D3C}\" 'is %errorlevel% >> %nnlog%
rd /s/q "%SystemRoot%\Installer\{D6C64C68-F9F5-11D3-BEEA-00A0CC272509}\"
echo Errorlevel from'rd /s/q "%SystemRoot%\Installer\{D6C64C68-F9F5-11D3-BEEA-00A0CC272509}\" 'is %errorlevel% >> %nnlog%
rd /s/q "%CommonProgramFiles%\Symantec Shared\Licenses\Scs\"
echo Errorlevel from' rd /s/q "%CommonProgramFiles%\Symantec Shared\Licenses\Scs\"'is %errorlevel% >> %nnlog%
rd /s/q "%SystemRoot%\Installer\{848AC794-8B81-440A-81AE-6474337DB527}\"
echo Errorlevel from'rd /s/q "%SystemRoot%\Installer\{848AC794-8B81-440A-81AE-6474337DB527}\" 'is %errorlevel% >> %nnlog%
rd /s/q "%SystemRoot%\Installer\{D1E5AC9D-DA9D-4167-8130-30B59D01F52D}\"
echo Errorlevel from'rd /s/q "%SystemRoot%\Installer\{D1E5AC9D-DA9D-4167-8130-30B59D01F52D}\" 'is %errorlevel% >> %nnlog%
rd /s/q "%SystemRoot%\Installer\{1F211E59-C268-4A86-ACC2-5B0CD153C26C}\"
echo Errorlevel from'rd /s/q "%SystemRoot%\Installer\{1F211E59-C268-4A86-ACC2-5B0CD153C26C}\" 'is %errorlevel% >> %nnlog%
rd /s/q "%ProgramFiles%\Symantec\AMS\"
echo Errorlevel from'rd /s/q "%ProgramFiles%\Symantec\AMS\" 'is %errorlevel% >> %nnlog%
rd /s/q "%CAppData%\Symantec\Common Client\"
echo Errorlevel from'rd /s/q "%CAppData%\Symantec\Common Client\" 'is %errorlevel% >> %nnlog%
rd /s/q "%CommonProgramFiles%\Symantec Shared\IDSDefs\"
echo Errorlevel from'rd /s/q "%CommonProgramFiles%\Symantec Shared\IDSDefs\" 'is %errorlevel% >> %nnlog%
rd /s/q "%CAppData%\Symantec\Symantec Client Firewall\"
echo Errorlevel from' rd /s/q "%CAppData%\Symantec\Symantec Client Firewall\"'is %errorlevel% >> %nnlog%
rd /s/q "%CommonProgramFiles%\Symantec Shared\AdBlocking\"
echo Errorlevel from'rd /s/q "%CommonProgramFiles%\Symantec Shared\AdBlocking\" 'is %errorlevel% >> %nnlog%
rd /s/q "%ProgramFiles%\Symantec Client Security\"
echo Errorlevel from'rd /s/q "%ProgramFiles%\Symantec Client Security\" 'is %errorlevel% >> %nnlog%
rd /s/q "%ProgramFiles%\Symantec Client Firewall\"
echo Errorlevel from'rd /s/q "%ProgramFiles%\Symantec Client Firewall\" 'is %errorlevel% >> %nnlog%

echo.>> %nnlog%
 

del /f/q "%SystemRoot%\system32\drivers\navap.sys"
del /f/q "%SystemRoot%\Enuams2.hlp"
del /f/q "%SystemRoot%\enuams2.cnt"
del /f/q "%SystemRoot%\enuams2.GID"
del /f/q "%SystemRoot%\ENUSAT.HLP"
del /f/q "%SystemRoot%\ENUSAT.CNT"
del /f/q "%SystemRoot%\ENUSAT.GID"
del /f/q "%SystemRoot%\vpc32.ini"
del /f/q "%SystemRoot%\system32\PDS.DLL"
del /f/q "%SystemRoot%\system32\CBA.DLL"
del /f/q "%SystemRoot%\system32\NTS.DLL"
del /f/q "%SystemRoot%\system32\AMS.DLL"
del /f/q "%SystemRoot%\system32\AMSUI.DLL"
del /f/q "%SystemRoot%\system32\AMSLIB.DLL"
del /f/q "%SystemRoot%\system32\CBAXFR.DLL"
del /f/q "%SystemRoot%\system32\Msgsys.dll"
del /f/q "%SystemRoot%\system32\ENUAMSUI.LRC"
del /f/q "%SystemRoot%\system32\ENUAMS.LRC"
del /f/q "%SystemRoot%\system32\BCSTHCFG.DLL"
del /f/q "%SystemRoot%\system32\ITMLHCFG.DLL"
del /f/q "%SystemRoot%\system32\MSBXHCFG.DLL"
del /f/q "%SystemRoot%\system32\NLMXHCFG.DLL"
del /f/q "%SystemRoot%\system32\NTELHCFG.DLL"
del /f/q "%SystemRoot%\system32\PAGEHCFG.DLL"
del /f/q "%SystemRoot%\system32\PRGXHCFG.DLL"
del /f/q "%SystemRoot%\system32\SNMPHCFG.DLL"
del /f/q "%SystemRoot%\system32\NTSU2T.DLL"
del /f/q "%SystemRoot%\system32\MSGSYS.EXE"
del /f/q "%SystemRoot%\system32\NavLogon.dll"
del /f/q "%SystemRoot%\system32\AMSDB.DLL"
del /f/q "%SystemRoot%\system32\AMSTRANS.DLL"
del /f/q "%temp%\SymClnUp.exe"
del /f/q "%SystemRoot%\system32\drivers\SymIDSCo.sys"
del /f/q "%SystemRoot%\system32\drivers\symredrv.sys"
del /f/q "%SystemRoot%\system32\drivers\symids.sys"
del /f/q "%SystemRoot%\system32\drivers\symndis.sys"
del /f/q "%SystemRoot%\system32\drivers\symdns.sys"
del /f/q "%SystemRoot%\system32\drivers\symfw.sys"
del /f/q "%SystemRoot%\system32\drivers\SymRedir.sys"
del /f/q "%SystemRoot%\system32\drivers\SymRedir.cat"
del /f/q "%SystemRoot%\system32\drivers\SymRedir.inf"
del /f/q "%SystemRoot%\system32\drivers\symtdi.sys"
del /f/q "%SystemRoot%\system32\SymNeti.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccEmlPxy.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccErrDsp.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccEvtMgr.exe"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccLgView.exe"
del /f/q "%CommonProgramFiles%\Symantec Shared\CCLGVIEW.CHM"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccAlert.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccApp.exe"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccProSub.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccProd.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccPwd.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccPwdSvc.exe"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccScan.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\ecmldr32.DLL"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccDec.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccSetMgr.exe"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccSetEvt.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccSet.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccVrTrst.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccWebWnd.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\Default.rul"
del /f/q "%CommonProgramFiles%\Symantec Shared\Validate.dat"
del /f/q "%CommonProgramFiles%\Symantec Shared\SNDSrvc.exe"
del /f/q "%CommonProgramFiles%\Symantec Shared\SNDInst.exe"
del /f/q "%CommonProgramFiles%\Symantec Shared\Persist.BAK"
del /f/q "%CommonProgramFiles%\Symantec Shared\Persist.Dat"
del /f/q "%CommonProgramFiles%\Symantec Shared\Help\ad_block.chm"
del /f/q "%windir%\System32\SymRedir.dll"
del /f/q "%windir%\Tasks\Symantec NetDetect.job"
del /f/q "%CommonProgramFiles%\Symantec Shared\actres.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccLogin.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccProxy.exe"
del /f/q "%CommonProgramFiles%\Symantec Shared\ccPxyEvt.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\CfgWiz.exe"
del /f/q "%CommonProgramFiles%\Symantec Shared\cfgwiz.tlb"
del /f/q "%CommonProgramFiles%\Symantec Shared\DPHTML.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\DPHTTP.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\DPJS.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\DPVBS.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\drWebWnd.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\Firewall.BAK"
del /f/q "%CommonProgramFiles%\Symantec Shared\Firewall.rul"
del /f/q "%CommonProgramFiles%\Symantec Shared\LocationMap.dat"
del /f/q "%CommonProgramFiles%\Symantec Shared\PFAdBlk.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\PFMisc.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\PFPriv.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\PFSec.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\profile.dat"
del /f/q "%CommonProgramFiles%\Symantec Shared\PxyHTTP.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\PxyIM.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\PxyNNTP.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\SMNLnch.exe"
del /f/q "%CommonProgramFiles%\Symantec Shared\SNDALRT.log"
del /f/q "%CommonProgramFiles%\Symantec Shared\SNDCON.log"
del /f/q "%CommonProgramFiles%\Symantec Shared\SNDDBG.log"
del /f/q "%CommonProgramFiles%\Symantec Shared\SNDFW.log"
del /f/q "%CommonProgramFiles%\Symantec Shared\SNDIDS.log"
del /f/q "%CommonProgramFiles%\Symantec Shared\SNDSYS.log"
del /f/q "%CommonProgramFiles%\Symantec Shared\StrmFilt.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\SymIConv.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\SymLCUI.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\SymLTCHK.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\SymLTCOM.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\SymUIAx.ocx"
del /f/q "%CommonProgramFiles%\Symantec Shared\SymUIHlp.dll"
del /f/q "%CommonProgramFiles%\Symantec Shared\TModule.Dat"
del /f/q "%StartMenuSt%\Symantec Client Firewall.lnk" 
del /f/q "%windir%\system32\symstore.dll"
del /f/q "%windir%\system32\SR.dat"
del /f/q "%windir%\system32\SR2.dat"
del /f/q "%windir%\system32\symneti.bkp"
del /f/q "%CommonProgramFiles%\Symantec Shared\BRUNOALE.DLL"
del /f/q "%CommonProgramFiles%\Symantec Shared\PProfile.dll"

if not "%REMOVE_LOGS%" == "1" goto SKIPLOGS
echo =========================== delete install logs ============================
del /f/q/a "%SystemRoot%\AMS2INST.LOG"
del /f/q/a "c:\_NavCSrv.Log"
del /f/q/a "c:\_NavCClt.Log"
del /f/q/a "c:\_SavCSrv.Log"
del /f/q/a "c:\_SavCClt.Log"
del /f/q/a "%windir%\temp\SCS_INST.LOG"
del /f/q/a "%windir%\temp\SSC_INST.LOG"
del /f/q/a "%windir%\temp\SAV_INST.LOG"
del /f/q/a "%temp%\SCS_INST.LOG"
del /f/q/a "%temp%\SSC_INST.LOG"
del /f/q/a "%temp%\SAV_INST.LOG"
del /f/q/a "c:\temp\SCS_INST.LOG"
del /f/q/a "c:\temp\SSC_INST.LOG"
del /f/q/a "c:\temp\SAV_INST.LOG"
:SKIPLOGS

echo ============== mark files in use to be deleted on next reboot ==============
if exist "%CommonProgramFiles%\Symantec Shared\SSC\*.*" for %%f in ("%CommonProgramFiles%\Symantec Shared\SSC\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%CommonProgramFiles%\Symantec Shared\SSC\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%CommonProgramFiles%\Symantec Shared\SSC\" && set needreboot=1
if exist "%ProgramFiles%\NAVNT\*.*" for %%f in ("%ProgramFiles%\NAVNT\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\NAVNT\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\NAVNT\" && set needreboot=1
if exist "%ProgramFiles%\NAV\*.*" for %%f in ("%ProgramFiles%\NAV\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\NAV\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\NAV\" && set needreboot=1
if exist "%ProgramFiles%\SAV\SAVRT\*.*" for %%f in ("%ProgramFiles%\SAV\SAVRT\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\SAV\SAVRT\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\SAV\SAVRT\" && set needreboot=1
if exist "%ProgramFiles%\SAV\*.*" for %%f in ("%ProgramFiles%\SAV\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\SAV\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\SAV\" && set needreboot=1
if exist "%ProgramFiles%\Symantec AntiVirus\SAVRT\*.*" for %%f in ("%ProgramFiles%\Symantec AntiVirus\SAVRT\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec AntiVirus\SAVRT\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec AntiVirus\SAVRT\" && set needreboot=1
if exist "%ProgramFiles%\Symantec AntiVirus\*.*" for %%f in ("%ProgramFiles%\Symantec AntiVirus\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec AntiVirus\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec AntiVirus\" && set needreboot=1
if exist "%ProgramFiles%\SSC\*.*" for %%f in ("%ProgramFiles%\SSC\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\SSC\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\SSC\" && set needreboot=1
if exist "%ProgramFiles%\Symantec_Client_Security\Symantec Client Firewall\*.*" for %%f in ("%ProgramFiles%\Symantec_Client_Security\Symantec Client Firewall\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec_Client_Security\Symantec Client Firewall\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec_Client_Security\Symantec Client Firewall\" && set needreboot=1
if exist "%ProgramFiles%\Symantec_Client_Security\Symantec Antivirus\*.*" for %%f in ("%ProgramFiles%\Symantec_Client_Security\Symantec Antivirus\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec_Client_Security\Symantec Antivirus\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec_Client_Security\Symantec Antivirus\" && set needreboot=1
if exist "%ProgramFiles%\Symantec_Client_Security\*.*" for %%f in ("%ProgramFiles%\Symantec_Client_Security\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec_Client_Security\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec_Client_Security\" && set needreboot=1
if exist "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\*.*" for %%f in ("%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\" && set needreboot=1
if exist "%ProgramFiles%\Symantec Client Security\Symantec Antivirus\SAVRT\*.*" for %%f in ("%ProgramFiles%\Symantec Client Security\Symantec Antivirus\SAVRT\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec Client Security\Symantec Antivirus\SAVRT\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec Client Security\Symantec Antivirus\SAVRT\" && set needreboot=1
if exist "%ProgramFiles%\Symantec Client Security\Symantec Antivirus\*.*" for %%f in ("%ProgramFiles%\Symantec Client Security\Symantec Antivirus\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec Client Security\Symantec Antivirus\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec Client Security\Symantec Antivirus\" && set needreboot=1
if exist "%ProgramFiles%\Symantec Client Security\*.*" for %%f in ("%ProgramFiles%\Symantec Client Security\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\Symantec Client Security\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\Symantec Client Security\" && set needreboot=1
if exist "%ProgramFiles%\SYMANTEC\Symantec System Center\*.*" for %%f in ("%ProgramFiles%\SYMANTEC\Symantec System Center\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%ProgramFiles%\SYMANTEC\Symantec System Center\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%ProgramFiles%\SYMANTEC\Symantec System Center\" && set needreboot=1
if exist "%SystemRoot%\system32\drivers\navap.sys" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\drivers\navap.sys" && set needreboot=1
if exist "%SystemRoot%\system32\PDS.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\PDS.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\CBA.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\CBA.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\NTS.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\NTS.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\AMS.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\AMS.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\AMSUI.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\AMSUI.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\AMSLIB.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\AMSLIB.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\CBAXFR.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\CBAXFR.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\Msgsys.dll" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\Msgsys.dll" && set needreboot=1
if exist "%SystemRoot%\system32\ENUAMSUI.LRC" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\ENUAMSUI.LRC" && set needreboot=1
if exist "%SystemRoot%\system32\ENUAMS.LRC" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\ENUAMS.LRC" && set needreboot=1
if exist "%SystemRoot%\system32\BCSTHCFG.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\BCSTHCFG.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\ITMLHCFG.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\ITMLHCFG.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\MSBXHCFG.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\MSBXHCFG.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\NLMXHCFG.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\NLMXHCFG.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\NTELHCFG.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\NTELHCFG.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\PAGEHCFG.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\PAGEHCFG.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\PRGXHCFG.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\PRGXHCFG.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\SNMPHCFG.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\SNMPHCFG.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\NTSU2T.DLL" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\NTSU2T.DLL" && set needreboot=1
if exist "%SystemRoot%\system32\MSGSYS.EXE" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\MSGSYS.EXE" && set needreboot=1
if exist "%SystemRoot%\system32\NavLogon.dll" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\NavLogon.dll" && set needreboot=1
if exist "%SystemRoot%\system32\drivers\SymIDSCo.sys" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\drivers\SymIDSCo.sys" && set needreboot=1
if exist "%SystemRoot%\system32\drivers\symredrv.sys" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\drivers\symredrv.sys" && set needreboot=1
if exist "%SystemRoot%\system32\drivers\symids.sys" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\drivers\symids.sys" && set needreboot=1
if exist "%SystemRoot%\system32\drivers\symndis.sys" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\drivers\symndis.sys" && set needreboot=1
if exist "%SystemRoot%\system32\drivers\symdns.sys" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\drivers\symdns.sys" && set needreboot=1
if exist "%SystemRoot%\system32\drivers\symfw.sys" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\drivers\symfw.sys" && set needreboot=1
if exist "%SystemRoot%\system32\drivers\SymRedir.sys" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\drivers\SymRedir.sys" && set needreboot=1
if exist "%SystemRoot%\system32\SymNeti.dll" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\SymNeti.dll" && set needreboot=1
if exist "%SystemRoot%\system32\drivers\symtdi.sys" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\drivers\symtdi.sys" && set needreboot=1
if exist "%SystemRoot%\system32\SymStore.dll" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\SymStore.dll" && set needreboot=1
if exist "%CommonProgramFiles%\Symantec Shared\ccLogin.dll" ESUGUnEn /LF"%nnlog%" /delatboot"%CommonProgramFiles%\Symantec Shared\ccLogin.dll" && set needreboot=1
if exist "%CommonProgramFiles%\Symantec Shared\ccProSub.dll" ESUGUnEn /LF"%nnlog%" /delatboot"%CommonProgramFiles%\Symantec Shared\ccProSub.dll" && set needreboot=1
if exist "%CommonProgramFiles%\Symantec Shared\ccPxyEvt.dll" ESUGUnEn /LF"%nnlog%" /delatboot"%CommonProgramFiles%\Symantec Shared\ccPxyEvt.dll" && set needreboot=1
if exist "%CommonProgramFiles%\Symantec Shared\ccSetEvt.dll" ESUGUnEn /LF"%nnlog%" /delatboot"%CommonProgramFiles%\Symantec Shared\ccSetEvt.dll" && set needreboot=1
if exist "%CommonProgramFiles%\Symantec Shared\ccSet.dll" ESUGUnEn /LF"%nnlog%" /delatboot"%CommonProgramFiles%\Symantec Shared\ccSet.dll" && set needreboot=1
if exist "%CommonProgramFiles%\Symantec Shared\ccVrTrst.dll" ESUGUnEn /LF"%nnlog%" /delatboot"%CommonProgramFiles%\Symantec Shared\ccVrTrst.dll" && set needreboot=1
if exist "%CommonProgramFiles%\Symantec Shared\CfgWiz.exe" ESUGUnEn /LF"%nnlog%" /delatboot"%CommonProgramFiles%\Symantec Shared\CfgWiz.exe" && set needreboot=1
if exist "%CommonProgramFiles%\Symantec Shared\cfgwiz.tlb" ESUGUnEn /LF"%nnlog%" /delatboot"%CommonProgramFiles%\Symantec Shared\cfgwiz.tlb" && set needreboot=1
if exist "%CommonProgramFiles%\Symantec Shared\drWebWnd.dll" ESUGUnEn /LF"%nnlog%" /delatboot"%CommonProgramFiles%\Symantec Shared\drWebWnd.dll" && set needreboot=1
if exist "%CommonProgramFiles%\Symantec Shared\AdBlocking\*.*" for %%f in ("%CommonProgramFiles%\Symantec Shared\AdBlocking\*.*") do ESUGUnEn /LF"%nnlog%" /delatboot"%%f"
if exist "%CommonProgramFiles%\Symantec Shared\AdBlocking\*.*" ESUGUnEn /LF"%nnlog%" /delatboot"%CommonProgramFiles%\Symantec Shared\AdBlocking\" && set needreboot=1
if exist "%SystemRoot%\system32\SymRedir.dll" ESUGUnEn /LF"%nnlog%" /delatboot"%SystemRoot%\system32\SymRedir.dll" && set needreboot=1

if "%REMOVE_DEFS%" == "1" echo =================== remove virus definitions/decomposers ===================
echo.>>%nnlog%
if "%REMOVE_DEFS%" == "1" rd /s/q "%CommonProgramFiles%\Symantec Shared\VirusDefs\"
echo Errorlevel from ' ' is %errorlevel% >> %nnlog%
if "%REMOVE_DEFS%" == "1" rd /s/q "%CommonProgramFiles%\Symantec Shared\Decomposers\"
echo Errorlevel from ' ' is %errorlevel% >> %nnlog%
if not "%REMOVE_SYMEVENT%" == "1" goto SKIPEVNT
echo ========================== remove symevent files ===========================
call :GetSymEvtApps
call :RemoveSymEvent

del /f/q "%SystemRoot%\system32\S32EVNT1.DLL"
echo Errorlevel from 'del /f/q "%SystemRoot%\system32\S32EVNT1.DLL" ' is %errorlevel% >> %nnlog%
del /f/q "%SystemRoot%\system32\SYMEVNT.386"
echo Errorlevel from 'del /f/q "%SystemRoot%\system32\SYMEVNT.386" ' is %errorlevel% >> %nnlog%
del /f/q "%SystemRoot%\system32\SYMEVNT1.DLL"
echo Errorlevel from 'del /f/q "%SystemRoot%\system32\SYMEVNT1.DLL" ' is %errorlevel% >> %nnlog%
del /f/q "%SystemRoot%\system32\drivers\SYMEVENT.SYS"
echo Errorlevel from 'del /f/q "%SystemRoot%\system32\drivers\SYMEVENT.SYS" ' is %errorlevel% >> %nnlog%
del /f/q "%ProgramFiles%\Symantec\SYMEVNT.386"
echo Errorlevel from 'del /f/q "%ProgramFiles%\Symantec\SYMEVNT.386" ' is %errorlevel% >> %nnlog%
del /f/q "%ProgramFiles%\Symantec\SYMEVNT1.DLL"
echo Errorlevel from 'del /f/q "%ProgramFiles%\Symantec\SYMEVNT1.DLL" ' is %errorlevel% >> %nnlog%
del /f/q "%ProgramFiles%\Symantec\S32EVNT1.DLL"
echo Errorlevel from 'del /f/q "%ProgramFiles%\Symantec\S32EVNT1.DLL" ' is %errorlevel% >> %nnlog%
del /f/q "%ProgramFiles%\Symantec\SYMEVENT.SYS"
echo Errorlevel from 'del /f/q "%ProgramFiles%\Symantec\SYMEVENT.SYS" ' is %errorlevel% >> %nnlog%
del /f/q "%ProgramFiles%\Symantec\SYMEVENT.INF"
echo Errorlevel from 'del /f/q "%ProgramFiles%\Symantec\SYMEVENT.INF" ' is %errorlevel% >> %nnlog%
del /f/q "%ProgramFiles%\Symantec\SYMEVENT.CAT"
echo Errorlevel from 'del /f/q "%ProgramFiles%\Symantec\SYMEVENT.CAT" ' is %errorlevel% >> %nnlog%
del /f/q "%CommonProgramFiles%\Symantec Shared\Sevinst.exe"
echo Errorlevel from 'del /f/q "%CommonProgramFiles%\Symantec Shared\Sevinst.exe"' is %errorlevel% >> %nnlog%
echo.>>%nnlog%
pause

:SKIPEVNT

if not "%REMOVE_LIVEUPDATE%" == "1" goto SKIPLUNT
echo ========================= remove liveupdate files ==========================
echo.>>%nnlog%
rd /s/q "%CAppData%\Symantec\LiveUpdate\"
echo Errorlevel from 'rd /s/q "%CAppData%\Symantec\LiveUpdate\" ' is %errorlevel% >> %nnlog%
rd /s/q "%ProgramFiles%\SYMANTEC\LiveUpdate\"
echo Errorlevel from 'rd /s/q "%ProgramFiles%\SYMANTEC\LiveUpdate\" ' is %errorlevel% >> %nnlog%
del /f/q "%CommonProgramFiles%\Symantec Shared\Help\LUALL.chm"
echo Errorlevel from 'del /f/q "%CommonProgramFiles%\Symantec Shared\Help\LUALL.chm" ' is %errorlevel% >> %nnlog%
del /f/q "%SystemRoot%\system32\s32lucp1.cpl"
echo Errorlevel from 'del /f/q "%SystemRoot%\system32\s32lucp1.cpl"' is %errorlevel% >> %nnlog%
echo.>>%nnlog%
echo ======================== remove liveupdate reg keys ========================
regedit /s nolu.reg
rem =================== remove liveupdate reg keys using .inf ===================
rundll32.exe setupapi,InstallHinfSection DefaultInstall 132 .\nolu.inf
:SKIPLUNT

if not "%REMOVE_CQUARANTINE%" == "1" goto SKIPQU
echo ================== remove quarantine server/console files ==================
rd /s/q "%ProgramFiles%\SYMANTEC\Quarantine\"
rd /s/q "%StartMenuPr%\Symantec Central Quarantine\"
rd /s/q "%StartMenuPr%\Symantec Quarantine Console\"
echo ================ remove quarantine server/console reg keys =================
regedit /s noquar.reg
rem =========== remove quarantine server/console reg keys using .inf ============
rundll32.exe setupapi,InstallHinfSection DefaultInstall 132 .\noquar.inf
:SKIPQU

:DELREG2
echo ====================== remove remaining registry keys ======================
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\webshell.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\vprpts.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\scandlgs.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\LotNtsUI.ocx"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\LDDateTm.ocx"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\LDVPCtls.ocx"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\LDVPDlgs.ocx"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\ldvpui.ocx"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\ExchngUI.ocx"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\LDVPTask.ocx"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\LDVPView.ocx"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\vpshell2.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\Transman.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\System32\pds.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\System32\msgsys.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\System32\nts.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\System32\cba.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\System32\NavLogon.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\SYSTEM\CBA.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\SYSTEM\NTS.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\SYSTEM\PDS.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\SYSTEM\Msgsys.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\LANGS\ENU\AMS2NT\Enuams2.hl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Xfr.ex_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\12520437.cp_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\12520850.cp_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Ams.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Ams2.ca_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Ams2.cfg"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Ams2inst.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msjet40.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Amsdb.md_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Amslib.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Amstrans.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Amsui.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Bcsthndl.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Caconfig.ex_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Cadb.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Casvc.ex_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Casvc.md_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Cauninst.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Cba.ca_"
echo 10%%
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Cba.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Cbadb.md_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Cbatl.md_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Cbaxfr.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Clutil_s.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Csl.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Cssm32s.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Cssm32s.si_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Cssms_in.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Ctinst.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Ctl3d32.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Ds16gt.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Ds32gt.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enuams.lr_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enuams2.cn_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enuams2.hl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enuamsui.lr_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enucacrc.lr_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enucain.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enucamgr.cn_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enucamgr.hl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enucasrc.lr_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enucmnrc.lr_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enuinst.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enupdsrc.lr_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enusat.cn_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enusat.hl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enusat.lr_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enuxfrrc.lr_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Hardware.cd_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Hardware.db_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Hndlrsvc.ex_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Iao.ex_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Indsm_s.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\InstallAMS.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Itmlhndl.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Ix509cls.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Ntsu2t.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Bcsthcfg.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Loc32vc0.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Loc32vc0.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Mfc42.dl_"
echo 20%%
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Mfc42enu.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Modemcfg.ex_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Modems.cd_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Modems.db_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msbxhndl.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Mscpxl32.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msgsys.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msgsys.ex_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msjet35.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msjint40.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msjter40.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msltus40.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msrd2x40.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msvcirt.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msvcrt.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msvcrt20.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msvcrt40.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msvcrt40.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Mtxdm.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Ntelhndl.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Nts.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbc16gt.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbc32.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbc32gt.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbcad32.ex_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbccp32.cp_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbccp32.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbccr32.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbcinst.cn_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbcinst.hl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbcint.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbcjet.cn_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbcjet.hl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbcji32.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbcjt32.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbctl32.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Odbctrac.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Origreg.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Origreg.il_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Ossapi.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Ossmem.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Pagehndl.dl_"
echo 30%%
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Pds.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Pds.ex_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Prgxhndl.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Services.cd_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Services.db_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Snmpat.ex_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Snmpat.ld_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Snmphndl.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Soedper.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Vbajet32.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Vbar332.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Wsdll32.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Itmlhcfg.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msbxhcfg.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Nlmxhcfg.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Ntelhcfg.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Pagehcfg.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Prgxhcfg.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Snmphcfg.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\amscust.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\SAV\Logon\NBPSHPOP.EXE"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\SAV\Logon\OSVER.EXE"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\SAV\Logon\VPLOGON.BAT"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\system32\CBA\pds.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\SAV\Logon\vp_log32.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\SAV\Logon\VP_LOGIN.INI"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\SAV\Logon\VPSCAN16.BAT"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\IMailUI.ocx"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\Symantec System Center\HELP\lic_snap.chm"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\Symantec System Center\LicSnap.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\SLICWrap.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\NavNT\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\NAV\Logon\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\NavNT\AMS2\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Norton AntiVirus\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Norton AntiVirus\AMS2\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Symantec System Center\Deployment\NT Remote Client Installation\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Symantec System Center\Ams2\Winnt\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Symantec System Center\Ams2\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Symantec System Center\HTML\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CommonProgramFiles%\Symantec Shared\SSC\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Symantec System Center\HELP\"
echo 40%%
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Symantec System Center\Tools\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\SAV\Logon\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\SAV\AMS2\Winnt\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\SAV\AMS2\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\SAV\Langs\Enu\AMS2NT\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\SAV\Langs\Enu\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\SAV\Langs\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%StartMenuPr%\Symantec System Center Console\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%StartMenuPr%\Symantec Client Security\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%StartMenuPr%\Alert Management Server\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%StartMenuPr%\Norton AntiVirus Corporate Edition\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%windir%\Installer\{5F5A0389-C8D6-49D6-8812-9F7F439E72AC}\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%windir%\Installer\{7D2B86CA-2D5D-469E-92ED-E56B62BD1D3C}\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%windir%\Installer\{1F211E59-C268-4A86-ACC2-5B0CD153C26C}\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%windir%\Installer\{1FB9B789-CFB6-48CD-A579-1D0A30F36435}\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CommonProgramFiles%\Symantec Shared\Licenses\Scs\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec_Client_Security\Symantec AntiVirus\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec_Client_Security\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\SAV\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%windir%\System32\cba\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\SAV\clt-inst\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\SAV\clt-inst\Win32\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec_Client_Security\Symantec AntiVirus\AMS2\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Nav\Alert\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%windir%\Installer\{D6C64C68-F9F5-11D3-BEEA-00A0CC272509}\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\SAV\I2_LDVP.VDB\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\SAV\SAVRT\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CAppData%\Symantec\Symantec AntiVirus Corporate Edition\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CAppData%\Symantec\Symantec AntiVirus Corporate Edition\7.5\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CAppData%\Symantec\Symantec AntiVirus Corporate Edition\7.5\APTemp\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CAppData%\Symantec\Symantec AntiVirus Corporate Edition\7.5\I2_LDVP.VDB\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CAppData%\Symantec\Symantec AntiVirus Corporate Edition\7.5\Logs\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CAppData%\Symantec\Symantec AntiVirus Corporate Edition\7.5\Quarantine\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\SAV\CLT-INST\WEBINST\webinst\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\SAV\CLT-INST\WEBINST\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\AMS\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\AMS\Langs\Enu\AMS2NT\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\AMS\Langs\Enu\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\AMS\Langs\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\AMS\AMS2\Winnt\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\AMS\AMS2\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%windir%\Installer\{848AC794-8B81-440A-81AE-6474337DB527}\"
echo 50%%
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%windir%\Installer\{D1E5AC9D-DA9D-4167-8130-30B59D01F52D}\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Symantec System Center\Langs\Enu\AMS2NT\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Symantec System Center\Langs\Enu\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Symantec System Center\Langs\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\ccEmlPxy.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\ccErrDsp.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\ccLgView.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\ccAlert.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\ccApp.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\ccProSub.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\ccProd.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\ccPwd.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\ccPwdSvc.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\ccSetEvt.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\ccSetMgr.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\ccSet.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\ccVrTrst.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\ccWebWnd.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\IDSDefs\IDSCoLU.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\IDSDefs\IDSLU.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SNDSrvc.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SNDInst.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CAppData%\Symantec\Common Client\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CommonProgramFiles%\Symantec Shared\IDSDefs\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec AntiVirus\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec AntiVirus\SAVRT\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec AntiVirus\Virus Defs\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec Client Security\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CAppData%\Symantec\Symantec Client Firewall\Temp\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CAppData%\Symantec\Symantec Client Firewall\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec Client Security\Symantec AntiVirus\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec Client Security\Symantec AntiVirus\SAVRT\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CommonProgramFiles%\Symantec Shared\AdBlocking\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec Client Security\Symantec AntiVirus\Virus Defs\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%windir%\Installer\{00CD72B3-E2DF-4DFC-BCC1-5CC4F564518D}\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\AdBlocking\AdTrash.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\AdBlocking\FREAdblk.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\AdBlocking\NSMdtr.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\AdBlocking\PxyLog.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\AdBlocking\SymWbOpt.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\AdBlocking\symad.dll"
echo 60%%
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\Help\ad_block.chm"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\PxyHTTP.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\PxyIM.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\PxyNNTP.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\DPJS.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\DPHTTP.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\DPVBS.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\DPHTML.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\PFAdBlk.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\PFMisc.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\PFPriv.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\PFSec.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\CfgWiz.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SMNLnch.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SymLCUI.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SymLTCHK.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SymLTCOM.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SymUIAx.ocx"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SymUIHlp.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\actres.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\cfgwiz.tlb"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\drWebWnd.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\firewall.rul"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\PProfile.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\AlertAst.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\AlertAst.tlb"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\cfgwiz.dat"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\CfgWzRes.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\CfgWzSvc.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\FIO.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\FREAles.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\FREIDS.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\FREInteg.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\FREMacro.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\FREProf.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\FREProps.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\FREPrvcy.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\FRERules.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\FRESPort.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\FRESettg.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\HNetCore.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\HNetWiz.exe"
echo 70%%
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\ISLAlert.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\ISSTE.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\LocWiz.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\LogFwder.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\NISAbout.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\NISPLUG.NSI"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\NISProd.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\NISVER.dat"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\NiSPlug.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\NisCfgWz.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\NisEmSvr.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\NisEmail.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\NisEvt.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\NisLUCbk.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\NisLVPlg.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\NisLog.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\NisRes.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\RLevel.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\SCFInteg.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\SNLog.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\SymSPort.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\TTracerPxy.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\WrapUM.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\Branding.ini"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\niscmnht.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\nislcom.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\nisopts.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec Client Security\Symantec Client Firewall\nissess.tpl"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec Client Security\Symantec AntiVirus\APTemp\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec Client Security\Symantec AntiVirus\I2_LDVP.VDB\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec Client Security\Symantec AntiVirus\Logs\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec Client Security\Symantec AntiVirus\Quarantine\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%windir%\Application Data\Microsoft\Installer\{00CD72B3-E2DF-4DFC-BCC1-5CC4F564518D}\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\SYSTEM\SymIDSCo.vxd"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\SYSTEM\SymRedir.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\SYSTEM32\SymStore.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\SYSTEM32\SymRedir.dll"
ESUGUnEn /LF"%nnlog%" /REGMSZEDIT"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DHCP" "DependOnService" "SYMTDI"
ESUGUnEn /LF"%nnlog%" /REGMSZEDIT"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NetBT" "DependOnService" "SYMTDI"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec_Client_Security\Symantec Client Firewall\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%windir%\Installer\{A6F7E997-2236-4145-A028-438F2484241A}\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "C:\PROGRA~1\SAV\Logon\"
echo 80%%
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "C:\PROGRA~1\SAV\AMS2\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "C:\PROGRA~1\SAV\AMS2\Winnt\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "C:\PROGRA~1\SAV\Langs\Enu\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "C:\PROGRA~1\SAV\Langs\Enu\AMS2NT\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "C:\PROGRA~1\SAV\Langs\Enu\AMS2NT\ENUAMS2.HL_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Amsdb.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Cmnrc.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enucamgr.cnt"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Enucamgr.hlp"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Jpnams2.cn_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Jpnams2.hl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Jpncamgr.cnt"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Jpncamgr.hlp"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Lcfinst.ex_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Lcfinst.pk_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msjint35.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msjter35.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msltus35.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Msrd2x35.dl_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\Pagesvc.in_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\NAV\AMS2\WINNT\_inst32i.ex_"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec AntiVirus\CLT-INST\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec AntiVirus\CLT-INST\WIN32\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec AntiVirus\I2_LDVP.VDB\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec AntiVirus\Logon\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec AntiVirus\CLT-INST\WEBINST\webinst\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec AntiVirus\Logon\VPSCAN16.BAT"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec AntiVirus\Logon\VP_LOGIN.INI"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec AntiVirus\Logon\vp_log32.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec AntiVirus\Logon\VPLOGON.BAT"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec AntiVirus\Logon\OSVER.EXE"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec AntiVirus\Logon\NBPSHPOP.EXE"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SSC\CCMailUI.ocx"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\PProfile.dll"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\BRUNOALE.DLL"
if not "%REMOVE_SYMEVENT%" == "1" goto SKIPEVREG
ESUGUnEn /LF"%nnlog%" /REGMSZEDIT"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\VirtualDeviceDrivers" "VDD" "%SystemDrive%\PROGRA~1\Symantec\S32EVNT1.DLL"
ESUGUnEn /LF"%nnlog%" /REGMSZEDIT"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\VirtualDeviceDrivers" "VDD" "%SystemDrive%\PROGRA~1\\Symantec\S32EVNT1.DLL"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SOFTWARE\Symantec\Symevent"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\VxD\SYMEVNT"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\SymEvent"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Sevinst"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SOFTWARE\Symantec\Managed Products\SymEvent"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "C:\PROGRA~1\Symantec\S32EVNT1.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "C:\PROGRA~1\Symantec\SYMEVENT.SYS"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "C:\PROGRA~1\Symantec\SYMEVNT.386"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "C:\PROGRA~1\Symantec\SYMEVNT1.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\SYMEVNT.386"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\SYMEVNT1.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\S32EVNT1.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\SYMEVENT.SYS"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\System32\SYMEVNT.386"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\System32\SYMEVNT1.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\System32\S32EVNT1.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\System32\Drivers\SYMEVENT.SYS"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%CommonProgramFiles%\Symantec Shared\SEVINST.EXE"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\SYSTEM\SYMEVNT.386"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\SYSTEM\S32EVNT1.DLL"
:SKIPEVREG
echo 90%%
if not "%REMOVE_LIVEUPDATE%" == "1" goto SKIPLUREG
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "C:\PROGRA~1\Symantec\LiveUpdate\S32LIVE1.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "C:\PROGRA~1\Symantec\LiveUpdate\S32LUIS1.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\LiveUpdate\S32LIVE1.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\LiveUpdate\S32LUHF1.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\LiveUpdate\S32LUHM1.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\LiveUpdate\S32LUIS1.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\LiveUpdate\S32LUUZ1.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\LiveUpdate\LIVEUPDT.HCT"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\LiveUpdate\LUALL.EXE"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\LiveUpdate\PRODUCTREGCOM.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%ProgramFiles%\Symantec\LiveUpdate\S32LUWI1.DLL"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\System\S32lucp1.cpl"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\LiveUpdate\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CAppData%\Symantec\LiveUpdate\LuMMInst\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CAppData%\Symantec\LiveUpdate\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\lusetup.exe"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SharedDLLs" "%windir%\system32\S32lucp1.cpl"
:SKIPLUREG
if not "%REMOVE_CQUARANTINE%" == "1" goto SKIPQUREG
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Quarantine\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Quarantine\Server\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Quarantine\Server\Ams2\Winnt\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Quarantine\Server\Ams2\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Quarantine\Console\Ams2\Winnt\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\Symantec\Quarantine\Console\Ams2\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%StartMenuPr%\Symantec Central Quarantine\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%StartMenuPr%\Symantec Quarantine Console\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%windir%\Installer\{2BEE3B33-03F4-4544-BBD0-F7D2840DF66F}\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%windir%\Installer\{86A46236-C44B-4217-81E9-6B691C82E1DD}\"
:SKIPQUREG
if not "%REMOVE_DEFS%" == "1" goto SKIPDEFREG
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%ProgramFiles%\SAV\Virus Defs\"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\SOFTWARE\Symantec\InstalledApps" "AVENGEDEFS"
ESUGUnEn /LF"%nnlog%" /DELKEY"HKEY_LOCAL_MACHINE\SOFTWARE\Symantec\SharedDefs"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\SOFTWARE\Symantec\InstalledApps" "Common Client Decomposers"
ESUGUnEn /LF"%nnlog%" /DELVAL"HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Installer\Folders" "%CommonProgramFiles%\Symantec Shared\Decomposers\"
:SKIPDEFREG
echo 100%%

if not "%OS%" == "Windows_NT" goto SKIPMSI
echo ==================== clean up microsoft installer files ====================
ESUGUnEn /LF"%nnlog%" /delmsicode"{1F211E59-C268-4A86-ACC2-5B0CD153C26C}"
ESUGUnEn /LF"%nnlog%" /delmsicode"{D6C64C68-F9F5-11D3-BEEA-00A0CC272509}"
ESUGUnEn /LF"%nnlog%" /delmsicode"{BD12EB47-DBDF-11D3-BEEA-00A0CC272509}"
ESUGUnEn /LF"%nnlog%" /delmsicode"{0EFC6259-3AD8-4CD2-BC57-D4937AF5CC0E}"
ESUGUnEn /LF"%nnlog%" /delmsicode"{7D2B86CA-2D5D-469E-92ED-E56B62BD1D3C}"
ESUGUnEn /LF"%nnlog%" /delmsicode"{5F5A0389-C8D6-49D6-8812-9F7F439E72AC}"
ESUGUnEn /LF"%nnlog%" /delmsicode"{1FB9B789-CFB6-48CD-A579-1D0A30F36435}"
ESUGUnEn /LF"%nnlog%" /delmsicode"{848AC794-8B81-440A-81AE-6474337DB527}"
ESUGUnEn /LF"%nnlog%" /delmsicode"{D1E5AC9D-DA9D-4167-8130-30B59D01F52D}"
ESUGUnEn /LF"%nnlog%" /delmsicode"{00CD72B3-E2DF-4DFC-BCC1-5CC4F564518D}"
ESUGUnEn /LF"%nnlog%" /delmsicode"{A6F7E997-2236-4145-A028-438F2484241A}"
ESUGUnEn /LF"%nnlog%" /delmsicode"{B5FDA445-CAC4-4BA6-A8FB-A7212BD439DE}"
ESUGUnEn /LF"%nnlog%" /delmsicode"{20C1F431-93B5-4D09-9175-54D0FC6FA8C9}"
if "%REMOVE_CQUARANTINE%" == "1" ESUGUnEn /LF"%nnlog%" /delmsicode"{2BEE3B33-03F4-4544-BBD0-F7D2840DF66F}"
if "%REMOVE_CQUARANTINE%" == "1" ESUGUnEn /LF"%nnlog%" /delmsicode"{86A46236-C44B-4217-81E9-6B691C82E1DD}"
if "%REMOVE_CQUARANTINE%" == "1" ESUGUnEn /LF"%nnlog%" /delmsicode"{72AC27E9-CB80-4022-B59A-99FDB3BC633F}"
if "%REMOVE_CQUARANTINE%" == "1" ESUGUnEn /LF"%nnlog%" /delmsicode"{D6E79EB8-7619-4E59-A5CE-6DF24E6EA36D}"
:SKIPMSI

:END
if "%needreboot%" == "0" echo ========== all files seems successfully deleted (no reboot needed) =========
if "%needreboot%" == "1" echo ========= not all files seems successfully deleted (reboot needed) =========
echo ======== REBOOT=%REBOOT% set in nonav.bat (0=never, 1=if needed, 2=always) ========
if not "%REBOOT%" == "1" if not "%REBOOT%" == "2" goto EXIT
if "%REBOOT%" == "1" if not "%needreboot%" == "1" goto EXIT
echo ================================== reboot ==================================
ESUGUnEn /LF"%nnlog%" /reboot /force

:EXIT
echo =================================== exit =================================== >> "%nnlog%"
echo. >> "%nnlog%"
echo.
echo ================================= exiting ==================================
echo Log file saved to "%nnlog%"
rem ====== if nonav files in c:\temp then delete (nonav.exe extracts here) ======
if exist C:\temp\ESUGUnEn.exe del C:\temp\ESUGUnEn.exe
if exist C:\temp\rtvstop.exe del C:\temp\rtvstop.exe
if exist C:\temp\nonav.inf del C:\temp\nonav.inf
if exist C:\temp\nolu.inf del C:\temp\nolu.inf
if exist C:\temp\noquar.inf del C:\temp\noquar.inf
if exist C:\temp\nonav.reg del C:\temp\nonav.reg
if exist C:\temp\nolu.reg del C:\temp\nolu.reg
if exist C:\temp\noquar.reg del C:\temp\noquar.reg
if exist C:\temp\nonav.pif del C:\temp\nonav.pif
if exist C:\temp\nonav.pdf del C:\temp\nonav.pdf
if exist C:\temp\nonav.txt del C:\temp\nonav.txt
if exist C:\temp\UnEngVar.bat del C:\temp\UnEngVar.bat
if exist C:\temp\UnEngVar.txt del C:\temp\UnEngVar.txt
if exist C:\temp\autorun.iff del C:\temp\autorun.iff
if exist C:\temp\nonav.bat del C:\temp\nonav.bat
